unit UnitFramer;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CPortCtl, CPort, ExtCtrls, ShellAPI;

type
  TForm1 = class(TForm)
    ComPort: TComPort;
    GroupBox1: TGroupBox;
    Button_ouvrir: TButton;
    Button1: TButton;
    GroupBox2: TGroupBox;
    Label_TrameDec: TLabel;
    Label_TrameHex: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    LabelLien: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button_ouvrirClick(Sender: TObject);
    procedure ComPortRxChar(Sender: TObject; Count: Integer);
    procedure LabelLienClick(Sender: TObject);
    procedure LabelLienMouseEnter(Sender: TObject);
    procedure LabelLienMouseLeave(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;
  buffer:string;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
ComPort.ShowSetupDialog;
end;

procedure TForm1.Button_ouvrirClick(Sender: TObject);
begin
if not(comport.Connected) then
begin
 comport.Open;
 Button_ouvrir.caption:='Fermer';
end
else
begin
 comport.Close;
 Button_ouvrir.caption:='Ouvrir';
end;
end;

procedure TForm1.ComPortRxChar(Sender: TObject; Count: Integer);
var
 Str:string;
 i:integer;
begin
  ComPort.ReadStr(Str, Count);
  buffer := buffer + Str;
  if (length(buffer)=11) then
  begin
   Label_TrameDec.caption:='';
   Label_TrameHex.caption:='';
   For i:=4 to 8 do
   begin
    Label_TrameDec.caption:=Label_TrameDec.caption+' '+IntToStr(Ord(buffer[i]));
    Label_TrameHex.caption:=Label_TrameHex.caption+' '+Inttohex(Ord(buffer[i]),2);
   end;
   buffer:='';
  end;
  if (length(buffer)>11) then buffer:='';
end;



procedure TForm1.LabelLienClick(Sender: TObject);
begin
 ShellExecute(GetDesktopWindow,'open',PChar('http://www.rdelectronique.com/'),nil,nil,SW_SHOWNORMAL);
end;

procedure TForm1.LabelLienMouseEnter(Sender: TObject);
begin
 LabelLien.Font.Color:=clRed;
end;

procedure TForm1.LabelLienMouseLeave(Sender: TObject);
begin
 LabelLien.Font.Color:=clBlue;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 if comport.Connected then comport.Close;
end;

end.
